#!/bin/sh
FTPSCRIPT=clubtech.fts
HOST=$1
LIB=$2
USER=$3
PASS=$4

usage() {
   echo " "
   echo "USAGE: ./ftpsrc.sh HOST LIB USERID PASSWORD"
   echo " "
   echo "     HOST = FTP server to send to (ex: as400.example.com)"
   echo "      LIB = IBM i library to put source code into (ex: QGPL)"
   echo "   USERID = UserID to log in with"
   echo " PASSWORD = Password to log in with"
   echo " "
}

buildscript() {
   echo "user $USER $PASS"
   echo "cd /qsys.lib/qgpl.lib"
   echo "quote site namefmt 0"
   echo "quote rcmd crtsrcpf file($LIB/QDDSSRC) rcdlen(92)"
   echo "quote rcmd crtsrcpf file($LIB/QRPGLESRC) rcdlen(112)"
   echo "quote rcmd crtsrcpf file($LIB/QSQLSRC) rcdlen(92)"
   echo "ascii"
   echo "put ARCASH.pf $LIB/QDDSSRC.ARCASH"
   echo "quote rcmd chgpfm file($LIB/QDDSSRC) mbr(ARCASH) srctype(pf)"
   echo "ascii"
   echo "put INVCSDT.lf $LIB/QDDSSRC.INVCSDT"
   echo "quote rcmd chgpfm file($LIB/QDDSSRC) mbr(INVCSDT) srctype(lf)"
   echo "ascii"
   echo "put INVDET.pf $LIB/QDDSSRC.INVDET"
   echo "quote rcmd chgpfm file($LIB/QDDSSRC) mbr(INVDET) srctype(pf)"
   echo "ascii"
   echo "put INVOICE.pf $LIB/QDDSSRC.INVOICE"
   echo "quote rcmd chgpfm file($LIB/QDDSSRC) mbr(INVOICE) srctype(pf)"
   echo "ascii"
   echo "put CUSTINV.rpgle $LIB/QRPGLESRC.CUSTINV"
   echo "quote rcmd chgpfm file($LIB/QRPGLESRC) mbr(CUSTINV) srctype(rpgle)"
   echo "ascii"
   echo "put CREATEPROC.sql $LIB/QSQLSRC.CREATEPROC"
   echo "quote rcmd chgpfm file($LIB/QSQLSRC) mbr(CREATEPROC) srctype(sql)"
   echo "quit"
}

if test "x$HOST" = "x" -o "x$LIB" = "x" -o "x$USER" = "x" -o "x$PASS" = "x"; then
  usage
  exit 1
fi

buildscript > $FTPSCRIPT
ftp -n $HOST < $FTPSCRIPT
rm -f $FTPSCRIPT
