      * CUSTINV:  A Sample UDTF That Generates a List of Invoices
      *           For a Customer Within A Given Number of Days Back
      *                                Scott Klement, May 2012
      *
      *  To compile:
      *>   CRTRPGMOD CUSTINV SRCFILE(*LIBL/QRPGLESRC) DBGVIEW(*LIST)
      *>   CRTSRVPGM CUSTINV MODULE(CUSTINV) EXPORT(*ALL)
      *>   DLTMOD CUSTINV
      *
     H NOMAIN

     FINVCSDT   IF   E           K DISK    USROPN
     FINVDET    IF   E           K DISK    USROPN
     FARCASH    IF   E           K DISK    USROPN

     P CustInvoices    b                   export
     D CustInvoices    pi
     D    custno                      4p 0 const
     D    daysback                    3p 0 const
     D    inv_no                      5a
     D    inv_date                     D   datfmt(*iso)
     D    inv_wgt                     9p 1
     D    inv_amt                     9p 2
     D    pay_sts                     1A
     D    n_custno                    5i 0 const
     D    n_daysback                  5i 0 const
     D    n_inv_no                    5i 0
     D    n_inv_date                  5i 0
     D    n_inv_wgt                   5i 0
     D    n_inv_amt                   5i 0
     D    n_pay_sts                   5i 0
     D    State_SQL                   5a
     D    Function                  517a   varying const
     D    Specific                  128a   varying const
     D    errorMsg                   70a   varying
     D    CallType                   10i 0 const

     D CALL_OPEN       C                   CONST(-1)
     D CALL_FETCH      C                   CONST(0)
     D CALL_CLOSE      C                   CONST(1)

     D PARM_NULL       C                   CONST(-1)
     D PARM_NOTNULL    C                   CONST(0)

     D INV             ds                  likerec(INVOICEF: *input)
     D DET             ds                  likerec(INVDETF: *input)
     D CASH            ds                  likerec(ARCASHF: *input)
     D StartDate       s               D   datfmt(*iso)
     D Status          s              1a
     D TotWgt          s                   like(Inv_Wgt)
     D Total           s                   like(Inv_Amt)
     D Subtotal        s                   like(Inv_Amt)
     D DiscAmt         s                   like(Inv_Amt)
     D ChgAmt          s                   like(Inv_Amt)

      /free

         if n_custno = PARM_NULL
             or n_daysback = PARM_NULL;
            State_SQL = '38999';
            errorMsg = 'Null parameters not allowed!';
         endif;

         select;
         when CallType = CALL_OPEN;
            exsr doOpen;
         when CallType = CALL_FETCH;
            exsr doFetch;
         when CallType = CALL_CLOSE;
            exsr doClose;
         endsl;

         return;


         //----------------------------------------------------
         //  this is called when the virtual table is "opened"
         //
         //  Here, I can perform any logic that I want to do
         //  once per function invocation.
         //----------------------------------------------------

         begsr doOpen;
            open INVCSDT;
            open ARCASH;
            open INVDET;

            startDate = %date() - %days(daysback);

            setll (CustNo: StartDate) INVCSDT;
         endsr;


         //----------------------------------------------------
         //  This is called any time the database wants to
         //  read (or "fetch") a record from the virtual table.
         //
         //  Here, I can do any RPG logic desired to calculate
         //  the column/field values to be returned.  In this
         //  example, I provide samples of how I might calculate
         //  an invoice total, weight, and payment status.
         //
         //  (This is somewhat simplified vs. what Klement's
         //  Sausage actually does.)
         //----------------------------------------------------
         begsr doFetch;

            // -------------------------------------
            // Get next invoice.
            // -------------------------------------

            reade (CustNo) INVCSDT INV;
            if %eof(INVCSDT);
               State_SQL = '02000';
               leavesr;
            endif;


            // -------------------------------------
            // Calculate invoice subtotal and weight
            // -------------------------------------

            Subtotal = 0;
            TotWgt = 0;

            setll (INV.InvNo: CustNo) INVDET;
            reade (INV.InvNo: CustNo) INVDET DET;

            dow not %eof(INVDET);

               Subtotal += DET.Price * DET.QtyShp;

               select;
               when DET.Unit = 'B';
                  TotWgt += DET.QtyShp * DET.LbsBox;
               when DET.Unit = 'P';
                  TotWgt += DET.QtyShp * DET.LbsPc;
               when DET.Unit = 'Z';
                  TotWgt += DET.QtyShp * DET.LbsPal;
               when DET.Unit = 'L';
                  TotWgt += DET.QtyShp;
               endsl;

               reade (INV.InvNo: CustNo) INVDET DET;
            enddo;

            // -------------------------------------
            // Calculate bottom-line discounts and
            //  charges.
            // -------------------------------------

            if DiscLbs <> 0;
               DiscAmt += TotWgt * DiscLbs;
            endif;
            if DiscDol <> 0;
               DiscAmt += Subtotal * DiscDol;
            endif;
            if ChgLbs <> 0;
               ChgAmt += TotWgt * ChgLbs;
            endif;
            if ChgDol <> 0;
               ChgAmt += Subtotal * ChgDol;
            endif;


            // -------------------------------------
            // Calculate invoice total
            // -------------------------------------

            Total = Subtotal + INV.ShipChg
                             + ChgAmt
                             - DiscAmt;


            // -------------------------------------
            // Check to see if customer has paid
            // -------------------------------------

            chain (CustNo: INV.InvNo: INV.InvDat) ARCASH CASH;
            if not %found(ARCASH);
               Status = 'N';
            elseif CASH.Amt < Total;
               Status = 'P';
            else;
               Status = 'Y';
            endif;


            // -------------------------------------
            // Return the fields (columns) that I
            //  calculated to the OS.
            // -------------------------------------

            n_inv_no   = PARM_NOTNULL;
            n_inv_date = PARM_NOTNULL;
            n_inv_wgt  = PARM_NOTNULL;
            n_inv_amt  = PARM_NOTNULL;
            n_pay_sts  = PARM_NOTNULL;

            inv_no   = INV.INVNO;
            inv_date = INV.INVDAT;
            inv_wgt  = TotWgt;
            inv_amt  = Total;
            pay_sts  = Status;

         endsr;


         //----------------------------------------------------
         //  This is called when the "virtual file" is closed.
         //  here, I can perform any logic that should be done
         //  once at the end of my function's invocation.
         //
         //  In this example, I simply close the files.
         //  In a more sophticated program, I might (when
         //  necessary) clean up temporary objects, delete
         //  overrides, end a communications session, or
         //  free up memory.  Anything that should be done
         //  once at the end of the session can be coded here.
         //----------------------------------------------------
         begsr doClose;
            close *all;
         endsr;

      /end-free
     P                 E
