      *  Child job to read an IFS directory recursively and
      *  write it to a pipe.  This is called by the IFSTREE1
      *  service program.
      *                           Scott Klement 06/28/2007
      *
      *  To compile:
      *    - Make sure the QLG_H and QP0LSTDI_H copy books are
      *        in a QRPGLESRC file in your library list.
      *    - CRTBNDRPG PGM(IFSTREE2) +
      *                SRCFILE(xxx/QRPGLESRC) DBGVIEW(*LIST)
      *
     H DFTACTGRP(*NO) ACTGRP(*NEW) BNDDIR('QC2LE')

      /copy qp0lstdi_h

     D IFSTREE2        PR                  ExtPgm('IFSTREE2')
     D   InPath                    1024A   options(*varsize)
     D IFSTREE2        PI
     D   InPath                    1024A   options(*varsize)

     D get_errno       PR              *   ExtProc('__errno')
     D errno           s             10I 0 based(p_Errno)

     D QCMDEXC         PR                  ExtPgm('QCMDEXC')
     D   cmd                      32702A   const options(*varsize)
     D   len                         15P 5 const
     D   igc                          3a   const options(*nopass)

     D ProcessObj      PR
     D   Status                      10I 0 const
     D   ErrVal                      10I 0 const
     D   RtnVal                      10I 0
     D   P                                 likeds(Qlg_Path_Name_t)

     D write           PR            10i 0 extproc('write')
     D   fd                          10i 0 value
     D   buf                           *   value
     D   size                        10u 0 value

     D close           PR            10i 0 extproc('close')
     D   fd                          10i 0 value

     D path            ds                  likeds(Qlg_Path_Name_t)
     D func            ds                  likeds(Qp0l_User_Function_t)
     D rc              s             10i 0
     D msg             s           1000a   varying
     D errind          s              2a   inz(x'FFFF')
     D cmd             s             50a   varying

      /free

           // **********************************************
           //  Tell the Qp0lProcessSubtree API to process
           //  all entries in the path name (given as parm).
           //  For each object found, call the ProcessObj()
           //  subprocedure.
           // **********************************************

           path                     = *ALLx'00';
           path.Path_Name           = %str(%addr(InPath));
           path.Path_Name_Delimiter = '/';
           path.Path_Length         = %len(%trimr(path.Path_Name));

           func               = *ALLx'00';
           func.Function_Type = QP0L_USER_FUNCTION_PTR;
           func.MltThdAcn     = QP0L_MLTTHDACN_NO;
           func.Procedure     = %paddr(ProcessObj);

           rc = Qp0lProcessSubtree( path
                                  : QP0L_SUBTREE_YES
                                  : *omit
                                  : QP0L_LOCAL_REMOTE_OBJ
                                  : *omit
                                  : QP0L_JOBLOG_NO_ERRORID
                                  : func
                                  : *null );

           // **********************************************
           //   Check to see if Qp0lProcessSubtree()
           //   received an error. If it did, send the
           //   error info to our caller via the pipe.
           // **********************************************

           if (rc = -1);
               p_errno = get_errno();
               if (errno = 0);
                  msg = 'IFSTREE2 failed, see job log';
                  cmd = 'DSPJOBLOG OUTPUT(*PRINT)';
                  QCMDEXC(cmd: %len(cmd));
               else;
                  msg = 'Qp0lProcessSubtree error CPE' + %char(errno);
               endif;
               callp write(1: %addr(errind): %size(errind));
               callp write(1: %addr(msg): %len(msg)+2);
           endif;

           callp close(1);

           *inlr = *on;

      /end-free


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * ProcessObj(): This is called by Qp0lProcessSubtree() for
      *               each object it finds.
      *
      *    status = (input) status code.  Can be one of the following:
      *                 QP0L_SELECT_OK     = No problems encountered
      *                 QP0L_SELECT_DONE   = All files were processed
      *                 QP0L_SELECT_NOT_OK = An error has occurred
      *                 QP0L_SELECT_FAILED = Error is causing abort
      *    ErrVal = (input) if status is an error, this contains
      *                 an errno value.
      *    RtnVal = (output) return value from this procedure,
      *                 should be a valid errno value upon failure.
      *         P = (input) path name structure (in Unicode format)
      *
      *  This procedure sets RtnVal to 0 if successful, or a positive
      *  number if an error occurs.
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P ProcessObj      B
     D ProcessObj      PI
     D   Status                      10I 0 const
     D   ErrVal                      10I 0 const
     D   RtnVal                      10I 0
     D   P                                 likeds(Qlg_Path_Name_t)

     D Name            s          16383C   based(p_Name) CCSID(1200)
     D File            s          16383A   varying static
     D CRLF            s              2a   inz(x'0d25') static

      /free
          RtnVal = 0;
          if (status = QP0L_SELECT_DONE);
             return;
          endif;

          // Extract path name from the path data structure
          // we received as a parm, and convert it to EBCDIC

          p_name = p.p_Path_Name;
          File   = %char( %subst( Name
                                : 1
                                : %div(p.Path_Length:2) ));

          // Write path name to the pipe

          callp write(1: %addr(File): %len(File)+2);

      /end-free
     P                 E
