      *  Sample UDTF to read an IFS directory recursively
      *                           Scott Klement 06/28/2007
      *
      *  To compile:
      *    - Make sure the IFSIO_H copybook is in a QRPGLESRC
      *        file in your library list.
      *    - Make sure the SPAWN_H copybook is in a QRPGLESRC
      *        file in your library list.
      *    - Compile the IFSTREE2 program (see the IFSTREE2 member
      *        for details) and put it in your library list.
      *    - CRTRPGMOD MODULE(IFSTREE1) +
      *                SRCFILE(xxx/QRPGLESRC) DBGVIEW(*LIST)
      *    - CRTSRVPGM IFSTREE1 EXPORT(*ALL)
      *    - Run the CRTIFSTREE program (see that member for details)
      *
      *  To call:
      *    This is run from an SQL SELECT statement.  See the
      *    IFSTREDEMO member for an example.
      *
      *
     H THREAD(*SERIALIZE) BNDDIR('QC2LE')

     D ifstree1        pr
     D    startdir                 1024A   varying const
     D    pathname                 5000A   varying
     D    size                       20p 0
     D    alcsize                    20p 0
     D    type                       10a   varying
     D    atime                        Z
     D    mtime                        Z
     D    ctime                        Z
     D    ccsid                       5p 0
     D    owner                      10a
     D    groupx                     10a
     D    n_startdir                  5i 0
     D    n_pathname                  5i 0
     D    n_size                      5i 0
     D    n_alcsize                   5i 0
     D    n_type                      5i 0
     D    n_atime                     5i 0
     D    n_mtime                     5i 0
     D    n_ctime                     5i 0
     D    n_ccsid                     5i 0
     D    n_owner                     5i 0
     D    n_group                     5i 0
     D    Sql_State                   5a
     D    Function                  517a   varying const
     D    Specific                  128a   varying const
     D    MsgText                    70a   varying
     D    CallType                   10i 0 const
     D ifstree1        pi
     D    startdir                 1024A   varying const
     D    pathname                 5000A   varying
     D    size                       20p 0
     D    alcsize                    20p 0
     D    type                       10a   varying
     D    atime                        Z
     D    mtime                        Z
     D    ctime                        Z
     D    ccsid                       5p 0
     D    owner                      10a
     D    groupx                     10a
     D    n_startdir                  5i 0
     D    n_pathname                  5i 0
     D    n_size                      5i 0
     D    n_alcsize                   5i 0
     D    n_type                      5i 0
     D    n_atime                     5i 0
     D    n_mtime                     5i 0
     D    n_ctime                     5i 0
     D    n_ccsid                     5i 0
     D    n_owner                     5i 0
     D    n_group                     5i 0
     D    Sql_State                   5a
     D    Function                  517a   varying const
     D    Specific                  128a   varying const
     D    MsgText                    70a   varying
     D    CallType                   10i 0 const

      /copy ifsio_h
      /copy spawn_h

     D spawnChild      PR            10i 0
     D   lib                         10a   const
     D   pgm                         10a   const
     D   StartDir                   500A   varying const
     D   pid                               like(pid_t)
     D readblock       PR            10i 0
     D   fd                          10i 0 value
     D   buf                           *   value
     D   size                        10u 0 value

     D Open_Event      PR
     D Fetch_Event     PR
     D Close_Event     PR

     D sys_errno       PR              *   ExtProc('__errno')
     D errno           s             10i 0 based(p_errno)
     D strerror        PR              *   ExtProc('strerror')
     D    errnum                     10I 0 value

     D CALL_STARTUP    C                   CONST(-2)
     D CALL_OPEN       C                   CONST(-1)
     D CALL_FETCH      C                   CONST(0)
     D CALL_CLOSE      C                   CONST(1)
     D CALL_FINAL      C                   CONST(2)

     D PARM_NULL       C                   CONST(-1)
     D PARM_NOTNULL    C                   CONST(0)

     D Epoch           s               z
     D cpid            s                   like(pid_t)
     D pdata           s             10i 0

      /free

          // -----------------------------------------
          // Verify that we received a directory name.
          // without that, there's nothing to be done.
          // -----------------------------------------

          if (n_startdir = PARM_NULL);
              SQL_State = '38999';
              MsgText = 'Directory name is required';
              return;
          endif;

          // -----------------------------------------
          //   Start all fields at NULL.
          // -----------------------------------------

          n_pathname = PARM_NULL;
          n_size     = PARM_NULL;
          n_alcsize  = PARM_NULL;
          n_atime    = PARM_NULL;
          n_mtime    = PARM_NULL;
          n_ctime    = PARM_NULL;
          n_type     = PARM_NULL;
          n_ccsid    = PARM_NULL;
          n_owner    = PARM_NULL;
          n_group    = PARM_NULL;

          // -----------------------------------------
          //  Open, Fetch & Close IFS directory stuff
          // -----------------------------------------

          select;
          when  CallType = CALL_OPEN;
            Open_Event();
          when  CallType = CALL_FETCH;
            Fetch_Event();
          when  CallType = CALL_CLOSE;
            Close_Event();
          endsl;

          return;
      /end-free


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * Open_Event(): This is called when SQL tells us to "open"
      *               the "table" that we're going to return.
      *
      *               We use it to do the following:
      *
      *                a) Calculate the time zone offset
      *                b) Ensure that the directory exists
      *                c) Spawn a child job to read the dir.
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P Open_Event      B
     D Open_Event      PI

     D CEEUTCO         PR                  opdesc
     D   Hours                       10I 0
     D   Minutes                     10I 0
     D   Seconds                      8F
     D   fc                          12A   options(*omit)

     D junk1           s             10i 0
     D junk2           s             10i 0
     D secs            s              8f
     D dirh            s               *

      /free

       // ----------------------------------------------
       // All Unix API timestamps are supplied as a count
       // of the number of seconds since the "epoch"
       // (which is defined as midnight, Jan 1, 1970 UTC)
       //
       // Since the epoch is in the UTC time zone, we
       // will need to adjust it for the local computer's
       // time...  To get the adjustment, use CEEUTCO.
       // ----------------------------------------------

          CEEUTCO(junk1: junk2: secs: *omit);
          Epoch = z'1970-01-01-00.00.00.000000'
                + %seconds(%int(secs));

       // ----------------------------------------------
       //   Check that we can open the directory
       // ----------------------------------------------

          dirh = opendir(%trim(startdir));
          if (dirh = *null);
             p_errno = sys_errno();
             MsgText = 'opendir: ' + %str(strerror(errno));
             SQL_State = '38998';
             return;
          endif;
          closedir(dirh);

       // ----------------------------------------------
       //  Spawn a new job that will read the IFS
       //  directory recursively...
       // ----------------------------------------------

          pdata = spawnChild('*LIBL': 'IFSTREE2': startdir: cpid);
          if (pdata = -1);
              return;
          endif;

          begsr *pssr;
            return;
          endsr;

      /end-free
     P                 E

      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * Fetch_Event(): This is called when SQL tells us to "fetch"
      *                a record from the "table".
      *
      *                a) Read the next IFS object name from the
      *                     child job (by reading a pipe)
      *                b) Get info about that object from the
      *                     lstat64() API
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P Fetch_Event     B
     D Fetch_Event     PI

     D error           s              1n   inz(*off)
     D info            ds                  likeds(statds64)
     D pathlen         s              5u 0
     D len             s             10i 0
     D own             ds                  likeds(passwd)
     D                                     based(p_own)
     D grp             ds                  likeds(group)
     D                                     based(p_grp)
      /free

              len = readblock(pdata: %addr(pathlen): %size(pathlen));
              if (len < %size(pathlen));
                  SQL_State = '02000';
                  return;
              endif;

              if (pathlen = *hival);
                 error = *on;
                 len = readblock(pdata: %addr(pathlen): %size(pathlen));
              endif;

              %len(pathname) = pathlen;
              len = readblock(pdata: %addr(pathname)+2: pathlen);
              if (len < pathlen);
                  SQL_State = '02000';
                  return;
              endif;
              if (error);
                  SQL_State = '38998';
                  MsgText = pathname;
                  return;
              endif;

              n_pathname = PARM_NOTNULL;

              if (lstat64(pathname: info) = -1);
                 p_errno = sys_errno();
                 MsgText = pathname + ': ' + %str(strerror(errno));
                 SQL_State = '38997';
                 return;
              endif;

              size = info.st_size;
              n_size = PARM_NOTNULL;

              alcsize = info.st_allocsize;
              n_alcsize = PARM_NOTNULL;

              type  = %trim(info.st_objtype);
              n_type = PARM_NOTNULL;

              atime = epoch + %seconds(info.st_atime);
              n_atime = PARM_NOTNULL;

              mtime = epoch + %seconds(info.st_mtime);
              n_mtime = PARM_NOTNULL;

              ctime = epoch + %seconds(info.st_ctime);
              n_ctime = PARM_NOTNULL;

              ccsid = info.st_ccsid;
              n_ccsid = PARM_NOTNULL;

              p_own = getpwuid(info.st_uid);
              if (p_own = *null);
                 owner = %char(info.st_uid);
                 n_owner = PARM_NOTNULL;
              else;
                 owner = %str(own.pw_name);
                 n_owner = PARM_NOTNULL;
              endif;

              p_grp  = getgrgid(info.st_gid);
              if (p_grp = *null);
                 groupx = %char(info.st_gid);
                 n_group = PARM_NOTNULL;
              else;
                 groupx = %str(grp.gr_name);
                 n_group = PARM_NOTNULL;
              endif;

              begsr *pssr;
                return;
              endsr;

      /end-free
     P                 E

      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * Close_Event(): This is called when SQL tells us to "close"
      *                our "table".
      *
      *                a) Close the pipe
      *                b) Wait for child job to complete.
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P Close_Event     B
     D Close_Event     PI
     D status          s             10i 0
      /free

          callp close(pdata);
          waitpid( -1: status: 0);

          begsr *pssr;
             return;
          endsr;
      /end-free
     P                 E


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * Create a new background "child" job.
      *
      *      lib = (input) library of program to launch
      *                    you can use *CURLIB or *LIBL
      *      pgm = (input) program name to launch
      * StartDir = (input) starting directory (passed to new job)
      *      pid = (output) process ID of new job
      *
      * Returns a pipe from which you can read the output of the
      *         spawned job, or -1 upon failure.
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P spawnChild      B
     D spawnChild      PI            10i 0
     D   lib                         10a   const
     D   pgm                         10a   const
     D   StartDir                   500A   varying const
     D   pid                               like(pid_t)

     D path            s            200a   varying
     D parms           s           1025a   dim(2)
     D envvar          s            100a   dim(1)
     D map             s             10i 0 dim(3)
     D argv            s               *   dim(5)
     D envp            s               *   dim(2)
     D inh             ds                  likeds(inheritance_t)
     D temppipe        s             10i 0 dim(2)

     D Null            c                   const(x'00')

     D OBJD0100        ds                  qualified
     D                                8a
     D   Object                      10A
     D                               20A
     D   Library                     10A

     D QUSROBJD        PR                  ExtPgm('QUSROBJD')
     D   RcvVar                   32767A   options(*varsize)
     D   RcvVarLen                   10I 0 const
     D   Format                       8A   const
     D   QualObj                     20A   const
     D   ObjType                     10A   const
     D   ErrorCode                 8000A   options(*varsize: *nopass)
     D   AspControl                 500A   const options(*varsize: *nopass)

     D ErrorCode       ds                  qualified
     D   BytesProv                   10I 0 inz(%size(ErrorCode))
     D   BytesAvail                  10I 0 inz(0)

      /free

          // ----------------------------------
          //  Find which library the child
          //  program is located in.
          //  (just in case *LIBL or *CURLIB
          //  was given)
          // ----------------------------------

           monitor;
              QUSROBJD( OBJD0100
                      : %size(OBJD0100)
                      : 'OBJD0100'
                      : pgm + lib
                      : '*PGM'
                      : ErrorCode );
           on-error;
              return -1;
           endmon;

          // ----------------------------------
          //  Create IFS-style path for pgm
          // ----------------------------------

           path       = '/QSYS.LIB'
                      + '/' + %trimr(OBJD0100.Library) + '.LIB'
                      + '/' + %trimr(OBJD0100.Object) + '.PGM'
                      + Null;


          // ----------------------------------
          //  Set up parameters for spawn() API
          // ----------------------------------

           parms(1)  = %trimr(OBJD0100.Object) + Null;
           parms(2)  = StartDir + Null;

           envvar(1) = 'QIBM_USE_DESCRIPTOR_STDIO=Y' + Null;

           inh       = *allx'00';
           argv(*)  = *null;
           envp(*)  = *null;
           argv(1)  = %addr(parms(1));
           argv(2)  = %addr(parms(2));
           envp(1)  = %addr(envvar(1));

           pipe(temppipe);

           map(1) = SPAWN_FDCLOSED;
           map(2) = temppipe(2);
           map(3) = temppipe(2);

          // ----------------------------------
          //  start the child job.
          // ----------------------------------

           pid = spawn( path: 3: map: inh: argv: envp);
           callp close(temppipe(2));

           if (pid = -1);
              p_errno = sys_errno();
              MsgText = 'spawn(): ' + %str(strerror(errno));
              SQL_State = '38996';
              callp close(temppipe(1));
           endif;

           return temppipe(1);
      /end-free
     P                 E


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      *  readblock():  Read a fixed-length chunk of data from
      *                a socket or pipe.
      *
      *       fd = (input) file descriptor to read from
      *      buf = (input) pointer to buffer to read into
      *     size = (input) size of buffer
      *
      * returns the length read or -1 upon utter failure
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P readblock       B
     D readblock       PI            10i 0
     D   fd                          10i 0 value
     D   buf                           *   value
     D   size                        10u 0 value

     D rc              s             10i 0
     D tot             s             10i 0

      /free

         tot = 0;

         dou (size = 0);

            rc = read(fd: buf: size);
            if (rc < 1);
               if (tot > 0);
                  return tot;
               else;
                  return -1;
               endif;
            endif;

            size = size - rc;
            buf = buf + rc;
            tot = tot + rc;

         enddo;

         return tot;
      /end-free
     P                 E
