      *   This registers the IFSTREE UDTF with the database.
      *   You only need to call this once, to install IFSTREE for
      *   the first time.
      *                                 Scott Klement, June 28, 2007
      *
      *   To compile:
      *      CRTSQLRPGI CRTIFSTREE SRCFILE(xxx/QRPGLESRC)
      *
      *   To call:
      *      CALL CRTIFSTREE PARM(my-lib)
      *      -  replace 'my-lib' with the name of the library where
      *         you placed the IFSTREE1 service program.
      *
      *
     D CrtIfsTree      PR                  ExtPgm('CRTIFSTREE')
     D   Lib                         10a   const
     D CrtIfsTree      PI
     D   Lib                         10a   const

     D ExtFunc         s             34A   varying
     D Stmt            s           5000A   varying
     D Msg             s             52a

     C/EXEC SQL
     C+   set option NAMING=*SYS,COMMIT=*NONE
     C/END-EXEC

     C                   if        %parms < 1
     C                   eval      msg='Usage: CALL CRTIFSTREE PARM(my-lib)'
     C                   dsply                   msg
     c                   return
     c                   endif

     C                   eval      ExtFunc=%trim(Lib)+'/IFSTREE1(IFSTREE1)'

     C*========================================================
     C* Delete the existing IFSTREE function (ignore any
     C* "not found" message.
     C*========================================================

     C/EXEC SQL
     C+                  drop function ifstree
     C/END-EXEC

     C                   if        %subst(sqlstate:1:2) > '02'
     c                             and sqlstate <> '42704'
     C                   eval      msg = 'drop failed w/SQLState '
     C                                 + sqlstate
     C     msg           dsply
     C                   endif

     C*========================================================
     C*   Create the new UDTF function
     C*========================================================
      /free

                 stmt = 'CREATE FUNCTION IFSTREE(startdir VARCHAR(500)) +
                               RETURNS TABLE +
                               ( +
                                 pathname    varchar(5000), +
                                 size        decimal(20,0), +
                                 alcsize     decimal(20,0), +
                                 type        varchar(10), +
                                 access_time timestamp, +
                                 modify_time timestamp, +
                                 change_time timestamp, +
                                 ccsid       decimal(5,0), +
                                 owner       char(10), +
                                 group       char(10) +
                               ) +
                         EXTERNAL NAME ''' + ExtFunc + ''' +
                         LANGUAGE RPGLE +
                         PARAMETER STYLE DB2SQL +
                         NO SQL +
                         NOT DETERMINISTIC +
                         NO EXTERNAL ACTION +
                         NOT FENCED +
                         NO SCRATCHPAD +
                         NO FINAL CALL +
                         DISALLOW PARALLEL +
                         CARDINALITY 1';
      /end-free

     C/EXEC SQL
     C+                  execute immediate :stmt
     C/END-EXEC

     C                   if        %subst(sqlstate:1:2) > '02'
     c                   eval      msg = 'create function SQLState '
     C                             + sqlstate
     C                   dsply                   msg
     C                   endif

     C                   eval      *inlr = *on
