      /if DEFINED(SIGNAL_H_INCLUDED)
      /eof
      /endif
      /define SIGNAL_H_INCLUDED

      *--------------------------------------------------------
      * Available signals
      *--------------------------------------------------------
     D SIGABRT         C                   const(1)
     D SIGIOT          C                   const(1)
     D SIGLOST         C                   const(1)
     D SIGFPE          C                   const(2)
     D SIGILL          C                   const(3)
     D SIGINT          C                   const(4)
     D SIGSEGV         C                   const(5)
     D SIGTERM         C                   const(6)
     D SIGUSR1         C                   const(7)
     D SIGUSR2         C                   const(8)
     D SIGIO           C                   const(9)
     D SIGAIO          C                   const(9)
     D SIGPTY          C                   const(9)
     D SIGALL          C                   const(10)
     D SIGOTHER        C                   const(11)
     D SIGKILL         C                   const(12)
     D SIGPIPE         C                   const(13)
     D SIGALRM         C                   const(14)
     D SIGHUP          C                   const(15)
     D SIGQUIT         C                   const(16)
     D SIGSTOP         C                   const(17)
     D SIGTSTP         C                   const(18)
     D SIGCONT         C                   const(19)
     D SIGCHLD         C                   const(20)
     D SIGCLD          C                   const(20)
     D SIGTTIN         C                   const(21)
     D SIGTTOU         C                   const(22)
     D SIGURG          C                   const(23)
     D SIGIOINT        C                   const(23)
     D SIGPOLL         C                   const(24)
     D SIGPCANCEL      C                   const(25)
     D SIGPALRM        C                   const(26)
     D SIGBUS          C                   const(32)
     D SIGDANGER       C                   const(33)
     D SIGPRE          C                   const(34)
     D SIGSYS          C                   const(35)
     D SIGTRAP         C                   const(36)
     D SIGPROF         C                   const(37)
     D SIGVTALRM       C                   const(38)
     D SIGXCPU         C                   const(39)
     D SIGXFSZ         C                   const(40)

      *--------------------------------------------------------
      * flags
      *--------------------------------------------------------
     D SA_NOCLDSTOP    c                   const(1)
     D SA_NODEFER      c                   const(2)
     D SA_RESETHAND    c                   const(4)
     D SA_SIGINFO      c                   const(8)

      *--------------------------------------------------------
      * sigprocmask() "how" argument
      *--------------------------------------------------------
     D SIG_BLOCK       c                   const(0)
     D SIG_UNBLOCK     c                   const(1)
     D SIG_SETMASK     c                   const(2)

      *--------------------------------------------------------
      *  sigset_t: signal set data structure
      *  ===================================
      *
      *  Note: There's not much point in trying to copy the
      *        way this is done in the ILE C header files,
      *        since RPG doesn't support integers that are
      *        1-bit long. Instead, I've defined the mask as
      *        one big field, and you can test/set bits with
      *        the %bitand() and %bitor() BIFs
      *--------------------------------------------------------
     D sigset_t        s             20U 0 based(TEMPLATE)

      *--------------------------------------------------------
      * sigaction_t: signal action data structure
      *
      * Prototype for signal handler (only if not SA_SIGINFO)
      *   D sa_handler      PR
      *   D   signo                       10I 0 value
      *
      * Prototype for signal action handler (only if SA_SIGINFO)
      *
      *   D sa_sigaction    PR
      *   D   signo                       10I 0 value
      *   D   info                              likeds(siginfo_t)
      *   D   context                       *   value
      *--------------------------------------------------------
     D sigaction_t     ds                  qualified
     D                                     align
     D                                     based(TEMPLATE)
     D   sa_handler                    *   procptr
     D   sa_mask                           like(sigset_t)
     D   sa_flags                    10I 0
     D   sa_sigaction                  *   procptr


      *--------------------------------------------------------
      * siginfo_t: signal information data structure
      *--------------------------------------------------------
     D siginfo_t       ds                  qualified
     D                                     align
     D                                     based(TEMPLATE)
     D   si_signo                    10I 0
     D   si_bits                      5U 0
     D   si_data_size                 5I 0
     D   si_time                      8A
     D   si_job                      10A
     D   si_user                     10A
     D   si_jobno                     6A
     D                                4A
     D   si_code                     10I 0
     D   si_errno                    10I 0
     D   si_pid                      10I 0
     D   si_uid                      10U 0
     D   si_data                      1A


      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * alarm(): Send an alarm signal after XX seconds
      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     D alarm           PR            10U 0 extproc('alarm')
     D   secs                        10U 0 value

      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * Qp0sEnableSignals():  Enable a process for signals
      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     D Qp0sEnableSignals...
     D                 PR            10I 0 extproc('Qp0sEnableSignals')

      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * Qp0sDisableSignals(): Disable signals
      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     D Qp0sDisableSignals...
     D                 PR            10I 0 extproc('Qp0sEnableSignals')

      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * default signal handlers
      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     D C_sig_err       PR                  extproc('_C_sig_err')
     D   signal                      10I 0 value
     D SIG_ERR         S               *   procptr inz(%paddr(C_sig_err))

     D C_sig_dfl       PR                  extproc('_C_sig_dfl')
     D   signal                      10I 0 value
     D SIG_DFL         S               *   procptr inz(%paddr(C_sig_dfl))

     D C_sig_ign       PR                  extproc('_C_sig_ign')
     D   signal                      10I 0 value
     D SIG_IGN         S               *   procptr inz(%paddr(C_sig_ign))

      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * sigaction():  Set signal action
      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     D sigaction       PR                  extproc('sigaction')
     D   sig                         10I 0 value
     D   act                               likeds(sigaction_t) const
     D                                     options(*omit)
     D   oact                              likeds(sigaction_t)
     D                                     options(*omit)

      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * sigaddset():  add signal to signal set
      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     D sigaddset       PR            10I 0 extproc('sigaddset')
     D   set                               like(sigset_t)
     D   signo                       10I 0 value


      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * sigdelset():  remove signal from signal set
      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     D sigdelset       PR            10I 0 extproc('sigdelset')
     D   set                               like(sigset_t)
     D   signo                       10I 0 value


      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * sigemptyset(): initialize an empty signal set
      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     D sigemptyset     PR            10I 0 extproc('sigemptyset')
     D   set                               like(sigset_t)


      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * sigfillset(): initialize a full signal set

      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     D sigfillset      PR            10I 0 extproc('sigfillset')
     D   set                               like(sigset_t)


      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * sigismember(): test if signal is in signal set
      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     D sigismember     PR            10I 0 extproc('sigismember')
     D   set                               like(sigset_t)
     D   signo                       10I 0 value


      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * signal(): set signal action (simplified version of
      *           sigaction() API)
      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     D signal          PR              *   procptr
     D                                     extproc('signal')
     D   sig                         10I 0 value
     D   handler                       *   procptr value


      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * sigpending(): examine pending signals
      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     D sigpending      PR            10I 0 extproc('sigpending')
     D   set                               like(sigset_t)


      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * sigprocmask(): Examine and change blocked signals
      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     D sigprocmask     PR            10I 0 extproc('sigprocmask')
     D   how                         10I 0 value
     D   set                               like(sigset_t)
     D                                     const
     D   oset                              like(sigset_t)


      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * sigsuspend(): replace signal mask and suspend
      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     D sigsuspend      PR            10I 0 extproc('sigsuspend')
     D   mask                              like(sigset_t)   const


      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * sigwait(): wait for a signal in a set
      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     D sigwait         PR            10I 0 extproc('sigwait')
     D   set                               like(sigset_t)   const

