      * This is a demonstration of a very simple TCP socket client
      * that sends e-mail to an SMTP server.
      *                                    Scott Klement, Oct 20, 2005
      *
      *  To compile:
      *     CRTBNDRPG CLIENT1 SRCFILE(xxx/QRPGLESRC) DBGVIEW(*LIST)
      *
     H dftactgrp(*no) bnddir('QC2LE')

      /copy socket_h
      /copy errno_h
      /copy signal_h

     D SendAscii       PR            10I 0
     D   sock                        10I 0 value
     D   data                      1024A   value
     D   timeout                     10I 0 value

     D GetReply        PR            10I 0
     D   sock                        10I 0 value
     D   timeout                     10I 0 value

     D Joblog          PR
     D   data                      1024A   const

     D init_signals    PR
     D got_alarm       PR
     D   signo                       10I 0 value

     D tconnect        PR            10I 0
     D   sock                        10I 0 value
     D   addr                          *   value
     D   size                        10I 0 value
     D   timeout                     10I 0 value
     D trecv           PR            10I 0
     D   sock                        10I 0 value
     D   data                          *   value
     D   size                        10I 0 value
     D   timeout                     10I 0 value
     D tsend           PR            10I 0
     D   sock                        10I 0 value
     D   data                          *   value
     D   size                        10I 0 value
     D   timeout                     10I 0 value

     D CRLF            C                   x'0d25'

     D user_addr       s            200A
     D addr            s             10U 0
     D port            s              5U 0
     D s               s             10I 0
     D connto          ds                  likeds(sockaddr_in)

     D get_errno       pr              *   ExtProc('__errno')
     D errno           s             10I 0 based(p_errno)

     D strerror        PR              *   ExtProc('strerror')
     D    errnum                     10I 0 value

      /free
          *inlr = *on;

          init_signals();
          user_addr = 'grungy.dstorm.net';

          // ---------------------------------------------------
          //  look up IP address & port number
          // ---------------------------------------------------
          addr = inet_addr(%trimr(user_addr));
          if (addr = INADDR_NONE);
              p_hostent = gethostbyname(%trimr(user_addr));
              if (p_hostent = *NULL);
                  joblog('Host lookup failed.');
                  return;
              else;
                  addr = h_addr;
              endif;
          endif;

          p_servent = getservbyname('smtp': 'tcp');
          if (p_servent <> *NULL);
             port = s_port;
          else;
             port = 25;
          endif;
          port = 139;

          // ---------------------------------------------------
          //   create a socket ("pick up the receiver")
          // ---------------------------------------------------

          s = socket(AF_INET: SOCK_STREAM: IPPROTO_TCP);
          if (s = -1);
             p_errno = get_errno();
             joblog('socket failed with errno=' + %char(errno));
             return;
          endif;

          // ---------------------------------------------------
          //   connect to server ("dial phone & wait for hello")
          //   give up after 30 seconds.
          // ---------------------------------------------------

          connto = *ALLx'00';
          connto.sin_family = AF_INET;
          connto.sin_addr   = addr;
          connto.sin_port   = port;

          if ( tconnect(s: %addr(connto): %size(connto): 30) = -1 );
             callp close(s);
             p_errno = get_errno();
             select;
              when  ( errno = ECONNREFUSED );
                joblog('No program is listening for connections '
                      + 'on port ' + %char(port));
              when  ( errno = EINTR );
                joblog('Connection attempt timed out!');
              other;
                joblog('connect(): ' + %str(strerror(errno)));
             endsl;
             return;
          endif;

          // ---------------------------------------------------
          //   SMTP servers send a 220 response as soon as
          //   they're connected.
          // ---------------------------------------------------

          if ( GetReply(s: 30) <> 220 );
             callp close(s);
             joblog('Not ready for SMTP requests.');
             return;
          endif;

          // ---------------------------------------------------
          //   Send the HELO command to tell the server who
          //   we are.
          // ---------------------------------------------------

          SendAscii(s: 'HELO example.com' + CRLF: 30);
          if ( GetReply(s: 30) <> 250 );
             callp close(s);
             joblog('HELO command failed!');
             return;
          endif;

          // ---------------------------------------------------
          //   Tell the server to accept a mail message from
          //    client1@iseriesnetwork.com
          // ---------------------------------------------------

          // NOTE: Change this to your E-mail address

          SendAscii(s: 'MAIL FROM:<client1@iseriesnetwork.com>'+CRLF: 30);
          if (GetReply(s:30) <> 250);
             callp close(s);
             joblog('MAIL command failed!');
             return;
          endif;

          // ---------------------------------------------------
          //   And send it to sklement@iseriesnetwork.com
          // ---------------------------------------------------

          // NOTE: Change this to the address of the person
          //       you'd like to send this to

          SendAscii(s: 'RCPT TO:<sklement@iseriesnetwork.com>'+CRLF: 30);
          if ( GetReply(s:30) <> 250 );
             callp close(s);
             joblog('RCPT command failed!');
             return;
          endif;

          // ---------------------------------------------------
          //   Tell the server that we're about to send the
          //   e-mail message.
          // ---------------------------------------------------

          SendAscii(s: 'DATA' + CRLF: 30);
          if ( GetReply(s:30) <> 354 );
             callp close(s);
             joblog('DATA command failed!');
             return;
          endif;

          // ---------------------------------------------------
          //   send the message.
          // ---------------------------------------------------

          SendAscii(s
          : 'From: Test Client 1 <client1@iseriesnetwork.com>' + CRLF
          + 'To: Scott Klement <sklement@iseriesnetwork.com>'  + CRLF
          + 'Subject: Testing'                                 + CRLF
          +                                                      CRLF
          + 'This is a test program.'                          + CRLF
          + '.'                                                + CRLF
          : 30 );

          if ( GetReply(s:30) <> 250 );
             callp close(s);
             joblog('Unable to send message.');
             return;
          endif;

          // ---------------------------------------------------
          //   Log off the server, and close the socket
          // ---------------------------------------------------

          SendAscii(s: 'QUIT' + CRLF : 30);
          GetReply(s:2);
          callp close(s);

      /end-free


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * This converts data to ASCII and then sends it.
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P SendAscii       B
     D SendAscii       PI            10I 0
     D   sock                        10I 0 value
     D   data                      1024A   value
     D   timeout                     10I 0 value

     D QDCXLATE        PR                  ExtPgm('QDCXLATE')
     D   Size                         5P 0 const
     D   Data                     32702A   options(*varsize)
     D   Table                       10A   const

     D len             s             10I 0
      /free
         joblog(data);
         len = %len(%trimr(data));
         QDCXLATE( len: data: 'QTCPASC' );
         return tsend(sock: %addr(data): len: Timeout);
      /end-free
     P                 E


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * Receive an SMTP response code.
      *
      *  This loops until it receives an entire SMTP response from
      *  the server, and then extracts the 3-digit number from
      *  the beginning of the response.
      *
      * FIXME: This does not handle multi-line responses!
      * FIXME: This assumes that the buffer will end with an
      *         ASCII x'0a' (linefeed) character.
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P GetReply        B
     D GetReply        PI            10I 0
     D   sock                        10I 0 value
     D   timeout                     10I 0 value

     D QDCXLATE        PR                  ExtPgm('QDCXLATE')
     D   Size                         5P 0 const
     D   Data                     32702A   options(*varsize)
     D   Table                       10A   const

     D data            s           1024A
     D p_data          s               *
     D tot             s             10I 0
     D left            s             10I 0
     D len             s             10I 0
     D reply           s             10I 0

     D atoi            pr            10I 0 extproc('atoi')
     D   input                         *   value options(*string)

      /free

         tot = 0;
         p_data = %addr(data);
         left = %size(data);

         dou %subst(data: tot: 1) = x'0a';

            len = trecv(sock: p_data: left: timeout);
            if (len < 1);
               return -1;
            endif;

            p_data = p_data + len;
            tot = tot + len;
            left = left - len;

         enddo;

         if (tot < 5);
            return -1;
         endif;

         QDCXLATE( tot: data: 'QTCPEBC' );
         monitor;
            joblog(data);
            reply = atoi(%subst(data:1:3));
         on-error;
            reply = -1;
         endmon;

         return reply;
      /end-free
     P                 E

      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * Write a message to the job log
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P Joblog          B
     D Joblog          PI
     D   data                      1024A   const

     D QMHSNDPM        PR                  ExtPgm('QMHSNDPM')
     D   MessageID                    7A   Const
     D   QualMsgF                    20A   Const
     D   MsgData                   1024A   Const
     D   MsgDtaLen                   10I 0 Const
     D   MsgType                     10A   Const
     D   CallStkEnt                  10A   Const
     D   CallStkCnt                  10I 0 Const
     D   MessageKey                   4A
     D   ErrorCode                 8192A   options(*varsize)

     D MsgKey          s              4A
     D ErrorCode       s              8A   inz(*allx'00')

      /free
         QMHSNDPM( 'CPF9897'
                 : 'QCPFMSG   *LIBL'
                 : data
                 : %len(%trimr(data))
                 : '*DIAG'
                 : '*'
                 : 0
                 : MsgKey
                 : ErrorCode );
      /end-free
     P                 E


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * Set up a signal handler to receive the SIGALRM signal
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P init_signals    B
     D init_signals    PI
     D act             ds                  likeds(sigaction_t)
      /free
          Qp0sEnableSignals();
          sigemptyset(act.sa_mask);
          sigaddset(act.sa_mask: SIGALRM);
          act.sa_handler   = %paddr(got_alarm);
          act.sa_flags     = 0;
          act.sa_sigaction = *NULL;
          sigaction(SIGALRM: act: *omit);
      /end-free
     P                 E


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * Whenever this program receives a SIGALRM signal, this
      * subprocedure will be called by the system
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P got_alarm       B
     D got_alarm       PI
     D   signo                       10I 0 value
      /free
         // Do nothing. The connect() API will return
         //  EINTR ("interrupted by signal") when the
         //  signal is received.
      /end-free
     P                 E


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * Connect with timeout
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P tconnect        B
     D tconnect        PI            10I 0
     D   sock                        10I 0 value
     D   addr                          *   value
     D   size                        10I 0 value
     D   timeout                     10I 0 value
     D rc              s             10I 0
      /free
          alarm(timeout);
          rc = connect(sock: addr: size);
          alarm(0);
          return rc;
      /end-free
     P                 E


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * Receive data with timeout
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P trecv           B
     D trecv           PI            10I 0
     D   sock                        10I 0 value
     D   data                          *   value
     D   size                        10I 0 value
     D   timeout                     10I 0 value
     D rc              s             10I 0
      /free
          alarm(timeout);
          rc = recv(sock: data: size: 0);
          alarm(0);
          return rc;
      /end-free
     P                 E


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * Send data with timeout
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P tsend           B
     D tsend           PI            10I 0
     D   sock                        10I 0 value
     D   data                          *   value
     D   size                        10I 0 value
     D   timeout                     10I 0 value
     D rc              s             10I 0
      /free
          alarm(timeout);
          rc = send(sock: data: size: 0);
          alarm(0);
          return rc;
      /end-free
     P                 E
