     /*-                                                                            +
      * Copyright (c) 2006 Scott C. Klement                                         +
      * All rights reserved.                                                        +
      *                                                                             +
      * Redistribution and use in source and binary forms, with or without          +
      * modification, are permitted provided that the following conditions          +
      * are met:                                                                    +
      * 1. Redistributions of source code must retain the above copyright           +
      *    notice, this list of conditions and the following disclaimer.            +
      * 2. Redistributions in binary form must reproduce the above copyright        +
      *    notice, this list of conditions and the following disclaimer in the      +
      *    documentation and/or other materials provided with the distribution.     +
      *                                                                             +
      * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND      +
      * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE       +
      * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE  +
      * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE     +
      * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL  +
      * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS     +
      * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)       +
      * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT  +
      * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY   +
      * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF      +
      * SUCH DAMAGE.                                                                +
      *                                                                             +
      */                                                                            +

      /if defined(SOCKUTIL_H_DEFINED)
      /eof
      /endif
      /define SOCKUTIL_H_DEFINED

      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * fdset = definition of a set of file descriptors
      *         (or socket descriptors)
      *
      *  By default, an fdset is 28 bytes long.  Each bit supports
      *  one descriptor, so by default you can have up to 224
      *  descriptors in a set.
      *
      *  If needed, you can increase the size of a descriptor set
      *  by defining your own.  If you do that, you need to follow
      *  these rules:
      *       a) The descriptor set has to be an even multiple of
      *            4 bytes long.
      *       b) Never make your set less than 28 bytes.
      *       c) When you call FD_ZERO, you must use the 2nd parm
      *            to tell it how many bytes long your set is.
      *       d) You must redefine it before you /copy or /include
      *            this member.
      *
      *  For example:
      *
      *         /define USER_FDSET_SIZE
      *        D fdset           s             64A
      *         /copy SOCKUTIL_H
      *
      *  The preceding code snippet would allow up to 512 descriptors.
      *  When I want to zero the set, I'd code:
      *
      *       callp FD_ZERO(fdset: %size(fdset))
      *
      *  You only need to redefine fdset if you need more than 224
      *  descriptors.  Otherwise, the definition below will suffice.
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      /if not defined(USER_FDSET_SIZE)
     D fdset           s             28A
      /endif

      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * Set a File Descriptor in a set ON...  for use w/Select()
      *
      *      fd = descriptor to set on
      *      set = descriptor set
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     D FD_SET          PR
     D   fd                          10I 0
     D   set                               like(fdset)


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * Set a File Descriptor in a set OFF...  for use w/Select()
      *
      *      fd = descriptor to set off
      *      set = descriptor set
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     D FD_CLR          PR
     D   fd                          10I 0
     D   set                               like(fdset)


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * Determine if a file desriptor is on or off...
      *
      *      fd = descriptor to set off
      *      set = descriptor set
      *
      *   Returns *ON if its on, or *OFF if its off.
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     D FD_ISSET        PR             1N
     D   fd                          10I 0
     D   set                               like(fdset)


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * Clear All descriptors in a set.  (also initializes at start)
      *
      *      set = descriptor set
      *  setsize = size of descriptor set (in bytes)
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     D FD_ZERO         PR
     D   set                      32767A   options(*varsize)
     D   setsize                     10I 0 value
      /if not defined(USER_FDSET_SIZE)
     D                                     options(*nopass)
      /endif


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * nbsocket():  Create a non-blocking socket
      *
      *    family = (input) communications domain ("protocol family")
      *      type = (input) socket type
      *  protocol = (input) protocol within family
      *
      * Returns new socket descriptor, or -1 upon failure (check errno!)
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     D nbsocket        pr            10i 0
     D    family                     10i 0 value
     D    type                       10i 0 value
     D    protocol                   10i 0 value


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * nbconnect(): Connect with a non-blocking socket and timeout
      *
      *    sock = (input) socket to connect
      *    addr = (input) sockaddr structure that denotes the
      *                   location to connect to.
      *    size = (input) size of preceding structure
      *    secs = (input) seconds to wait for connection before
      *                   timing out.
      *
      * Returns 0 if successful, or -1 upon error (check errno!)
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     D nbconnect       pr            10i 0
     D    sock                       10i 0 value
     D    addr                         *   value
     D    size                       10i 0 value
     D    secs                       10i 0 value


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * nbaccept(): Wait for a new client connection or timeout
      *             on a non-blocking socket
      *
      *    sock = (input) listener socket to accept from
      *    addr = (output) sockaddr structure that specifies who
      *                    the connection is from (or *NULL)
      *    size = (in/out) size of preceding structure, or *OMIT
      *                    if preceding structure is *NULL
      *    secs = (input) seconds to wait for new connection
      *                   before timing out.
      *
      * Returns new socket descriptor if successful,
      *         or -1 upon failure (check errno!)
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     D nbaccept        pr            10i 0
     D    sock                       10i 0 value
     D    addr                         *   value
     D    size                       10i 0 options(*omit)
     D    secs                       10i 0 value


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * nbrecv(): Receive data on non-blocking socket w/timeout
      *
      *    sock = (input) socket to receive data from
      *     buf = (output) buffer to receive into (address of variable)
      *    size = (input) size of buffer to send (size of variable)
      *    secs = (input) seconds to wait before timing out
      *
      * Returns length received, or -1 upon failure (check errno!)
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     D nbrecv          pr            10i 0
     D    sock                       10i 0 value
     D    buf                          *   value
     D    size                       10i 0 value
     D    secs                       10p 3 value


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * nbsend(): Send data on non-blocking socket w/timeout
      *
      *    sock = (input) socket to send data on
      *     buf = (input) buffer to send
      *    size = (input) size of buffer to send
      *    secs = (input) seconds to wait before timing out
      *
      * Returns length sent, or -1 upon failure (check errno!)
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     D nbsend          pr            10i 0
     D    sock                       10i 0 value
     D    buf                          *   value
     D    size                       10i 0 value
     D    secs                       10p 3 value

      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * bsocket():  Create a blocking socket
      *
      *    family = (input) communications domain ("protocol family")
      *      type = (input) socket type
      *  protocol = (input) protocol within family
      *
      * Returns new socket descriptor, or -1 upon failure (check errno!)
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     D bsocket         pr            10i 0
     D    family                     10i 0 value
     D    type                       10i 0 value
     D    protocol                   10i 0 value


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * bconnect(): Connect with a blocking socket w/timeout
      *
      *    sock = (input) socket to connect
      *    addr = (input) sockaddr structure that denotes the
      *                   location to connect to.
      *    size = (input) size of preceding structure
      *    secs = (input) seconds to wait for connection before
      *                   timing out.
      *
      * Returns 0 if successful, or -1 upon error (check errno!)
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     D bconnect        pr            10i 0
     D    sock                       10i 0 value
     D    addr                         *   value
     D    size                       10i 0 value
     D    secs                       10i 0 value

      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * baccept(): Accept connection with a blocking socket w/timeout
      *
      *    sock = (input) listener socket to accept from
      *    addr = (output) sockaddr structure that specifies who
      *                    the connection is from (or *NULL)
      *    size = (in/out) size of preceding structure, or *OMIT
      *                    if preceding structure is *NULL
      *    secs = (input) seconds to wait for new connection
      *                   before timing out.
      *
      * Returns new socket descriptor if successful,
      *         or -1 upon failure (check errno!)
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     D baccept         pr            10i 0
     D    sock                       10i 0 value
     D    addr                         *   value
     D    size                       10i 0 options(*omit)
     D    secs                       10i 0 value

      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * nbrecv(): Receive data on non-blocking socket w/timeout
      *
      *    sock = (input) socket to receive data from
      *     buf = (output) buffer to receive into (address of variable)
      *    size = (input) size of buffer to send (size of variable)
      *    secs = (input) seconds to wait before timing out
      *
      * Returns length received, or -1 upon failure (check errno!)
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     D brecv           pr            10i 0
     D    sock                       10i 0 value
     D    buf                          *   value
     D    size                       10i 0 value
     D    secs                       10p 3 value

      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * nbsend(): Send data on non-blocking socket w/timeout
      *
      *    sock = (input) socket to send data on
      *     buf = (input) buffer to send
      *    size = (input) size of buffer to send
      *    secs = (input) seconds to wait before timing out
      *
      * Returns length sent, or -1 upon failure (check errno!)
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     D bsend           pr            10i 0
     D    sock                       10i 0 value
     D    buf                          *   value
     D    size                       10i 0 value
     D    secs                       10p 3 value
