      * Service Program for parsing Excel spreadsheets (Event Model)
      *
      * To compile:
      *>      CHGCURLIB CURLIB(TIPSNL)
      *>      CRTRPGMOD MODULE(XLPARSER4) DBGVIEW(*ALL)
      *>      CRTSRVPGM SRVPGM(XLPARSER4) MODULE(XLPARSER4) -
      *>                EXPORT(*SRCFILE) SRCMBR(XLPARSER4) -
      *>                ACTGRP(XLPARSE)
      *> ign: CRTBNDDIR BNDDIR(XLPARSE)
      *> ign: ADDBNDDIRE BNDDIR(XLPARSE) OBJ((XLPARSER4 *SRVPGM))
      *
      *
     H NOMAIN OPTION(*SRCSTMT: *NODEBUGIO: *NOSHOWCPY)

      /copy xlparse_h

     D CLASS           C                   'com.iseriesnetwork.clubtech.-
     D                                     xlparse.ParseSheet'
     D CBCLASS         C                   'com.iseriesnetwork.clubtech.-
     D                                     xlparse.ParseSheetCallback'

     D callbackStringCell...
     D                 PR                  ExtProc(*JAVA: CBCLASS:
     D                                             'callbackStringCell')
     D                                     static
     D  Sheet                      1024A   const varying
     D  Row                          10I 0 value
     D  Column                        5I 0 value
     D  Value                     32767A   const varying

     D callbackNumericCell...
     D                 PR                  ExtProc(*JAVA: CBCLASS:
     D                                             'callbackNumericCell')
     D                                     static
     D  Sheet                      1024A   const varying
     D  Row                          10I 0 value
     D  Column                        5I 0 value
     D  Value                         8F   value

     D callbackFormulaCell...
     D                 PR                  ExtProc(*JAVA: CBCLASS:
     D                                             'callbackFormulaCell')
     D                                     static
     D  Sheet                      1024A   const varying
     D  Row                          10I 0 value
     D  Column                        5I 0 value
     D  Value                         8F   value
     D  Nan                           5I 0 value
     D  Formula                   32767A   const varying

     D StringProc      PR             1N   ExtProc(pStringProc)
     D   Sheet                     1024A   varying const
     D   Row                         10I 0 value
     D   Column                       5I 0 value
     D   Value                    32767A   varying const

     D NumericProc     PR             1N   ExtProc(pNumericProc)
     D   Sheet                     1024A   varying const
     D   Row                         10I 0 value
     D   Column                       5I 0 value
     D   Value                        8F   value

     D FormulaProc     PR             1N   ExtProc(pFormulaProc)
     D   Sheet                     1024A   varying const
     D   Row                         10I 0 value
     D   Column                       5I 0 value
     D   Value                        8F   value
     D   Nan                          5I 0 value
     D   Formula                  32767A   varying const

     D EndRowProc      PR                  ExtProc(pEndRowProc)
     D   Sheet                     1024A   varying const
     D   Row                         10I 0 value

     D NewRowProc      PR                  ExtProc(pNewRowProc)
     D   Sheet                     1024A   varying const
     D   Row                         10I 0 value

     D Escape          PR             1N
     D   StackCnt                    10I 0 value
     D   MsgTxt                     256A   const

     D Last            ds                  qualified
     D   Sheet                     1024a   varying inz('*NONE')
     D   Row                         10i 0 inz(-1)

     D pStringProc     s               *   procptr inz(*NULL)
     D pNumericProc    s               *   procptr inz(*NULL)
     D pFormulaProc    s               *   procptr inz(*NULL)
     D pEndRowProc     s               *   procptr inz(*NULL)
     D pNewRowProc     s               *   procptr inz(*NULL)

     D PSDS           SDS                  qualified
     D  job                  244    253A
     D  user                 254    263A
     D  jobnbr               264    269A


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * xlparse_notify():  Enable notifications.  This will cause
      *      XLPARSER4 to call subprocedures before and after
      *      each row that's read from the spreadsheet.
      *
      *    StartRow = (input) routine to call when a row begins
      *      EndRow = (input) routine to call when a row ends
      *
      * You can set one/both of these procedure pointers to *NULL
      * if you do not want to receive notification callbacks for
      * before/after events.
      *
      * A callback for either routine (before or after) should be
      * prototyped like this:
      *
      *      D mycallback      PR
      *      D  Sheet                      1024A   const varying
      *      D  Row                          10I 0 value
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P xlparse_notify...
     P                 B                   EXPORT
     D xlparse_notify...
     D                 PI
     D   startRow                      *   value procptr
     D   endRow                        *   value procptr
      /free
         pNewRowProc = startRow;
         pEndRowProc = endRow;
      /end-free
     P                 e


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * xlparse_workbook(): Parse the contents of an XLS workbook
      *
      *      Filename = /path/to/my/file.xls
      *       Numeric = procedure to call for each numeric cell in sheet
      *        String = procedure to call for each string cell in sheet
      *       Formula = procedure to call for each formula cell in sheet
      *
      * Returns 0 if successful, or -1 when a Java exception occurs
      *
      *  Callback procedures should be prototyped as follows:
      *
      *  D MyString        PR             1N
      *  D   Sheet                     1024A   varying const
      *  D   Row                         10I 0 value
      *  D   Col                          5I 0 value
      *  D   Value                    32767A   varying const
      *
      *  D MyNumeric       PR             1N
      *  D   Sheet                     1024A   varying const
      *  D   Row                         10I 0 value
      *  D   Col                          5I 0 value
      *  D   Value                        8F   value

      *  D MyFormula       PR             1N
      *  D   Sheet                     1024A   varying const
      *  D   Row                         10I 0 value
      *  D   Col                          5I 0 value
      *  D   Value                        8F   value
      *  D   Nan                          5I 0 value
      *  D   Formula                  32767A   varying const
      *
      *  The following information is sent to them:
      *
      *          Sheet = name of worksheet
      *            Row = row number (where 0 is the first row)
      *            Col = column number (where 0=A, 1=B, etc)
      *          Value = numeric or string of formula value of cell
      *
      *   You may return *ON to cancel processing, or *OFF otherwise
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P xlparse_workbook...
     P                 B                   EXPORT
     D xlparse_workbook...
     D                 PI            10I 0
     D    Filename                 1024A   const varying
     D    Numeric                      *   procptr value
     D    String                       *   procptr value
     D    Formula                      *   procptr value options(*nopass)
     D    RetainLog                    N   const options(*nopass:*omit)

     D unlink          PR            10I 0 ExtProc('unlink')
     D   path                          *   Value options(*string)

     D ParseSheet_parse...
     D                 PR                  ExtProc(*JAVA: CLASS: 'parse')
     D                                     static
     D    Filename                 1024A   const varying
     D    StdOut                   1024A   const varying
     D    StdErr                   1024A   const varying

     D Retain          s                   like(RetainLog)
     D StdOut          s           1024A   varying
     D StdErr          s           1024A   varying
     D RC              s             10I 0

      /free
            if (%parms() >= 4);
                pFormulaProc = Formula;
            else;
                pFormulaProc = *null;
            endif;

            if (%parms() >= 5 and %addr(RetainLog)<>*NULL);
                Retain = RetainLog;
            else;
                Retain = *off;
            endif;


            StdOut = '/tmp/' + %trim(PSDS.user) + '-' +
                               %trim(PSDS.job)  + '-' +
                               %trim(PSDS.jobnbr)+'-' +
                               'hssf-stdout.log';

            StdErr = '/tmp/' + %trim(PSDS.user) + '-' +
                               %trim(PSDS.job)  + '-' +
                               %trim(PSDS.jobnbr)+'-' +
                               'hssf-stderr.log';


            pNumericProc = Numeric;
            pStringProc = String;

            RC = 0;

            monitor;
               ParseSheet_parse(Filename: StdOut: StdErr);
            on-error;
               RC = -1;
            endmon;

            if (Last.Row>=0 and pEndRowProc<>*NULL);
               EndRowProc(Last.Sheet: Last.Row);
            endif;

            if not Retain;
               unlink(StdErr);
               unlink(StdOut);
            endif;

            return RC;

      /end-free
     P                 E

      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * hssf_callback_numeric_cell():  This is called back by Java
      *   for each numeric cell in a spreadsheet.
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P callbackNumericCell...
     P                 B                   EXPORT
     D callbackNumericCell...
     D                 PI                  static
     D  Sheet                      1024A   const varying
     D  Row                          10I 0 value
     D  Col                           5I 0 value
     D  Value                         8F   value
      /free
          if (Last.Row<>Row or Last.Sheet<>Sheet);
              if (Last.Row>=0 and pEndRowProc<>*NULL);
                 EndRowProc(Last.Sheet: Last.Row);
              endif;
              if (pNewRowProc<>*NULL);
                 NewRowProc(Sheet: Row);
              endif;
              Last.Sheet = Sheet;
              Last.Row   = Row;
          endif;

          if (pNumericProc <> *NULL);
             if (NumericProc(Sheet: Row: Col: Value) = *On);
                escape(1: 'End Of Data');
             endif;
          endif;

      /end-free
     P                 E


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * hssf_callback_string_cell():  This is called back by Java
      *   for each string cell ("label") in a spreadsheet.
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P callbackStringCell...
     P                 B                   EXPORT
     D callbackStringCell...
     D                 PI                  static
     D  Sheet                      1024A   const varying
     D  Row                          10I 0 value
     D  Col                           5I 0 value
     D  Value                     32767A   const varying

      /free
          if (Last.Row<>Row or Last.Sheet<>Sheet);
              if (Last.Row>=0 and pEndRowProc<>*NULL);
                 EndRowProc(Last.Sheet: Last.Row);
              endif;
              if (pNewRowProc<>*NULL);
                 NewRowProc(Sheet: Row);
              endif;
              Last.Sheet = Sheet;
              Last.Row   = Row;
          endif;

          if (pStringProc <> *NULL);
             if (StringProc(Sheet: Row: Col: Value) = *On);
                escape(1: 'End Of Data');
             endif;
          endif;

      /end-free
     P                 E

      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * hssf_callback_formula_cell():  This is called back by Java
      *   for each formula cell in a spreadsheet.
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P callbackFormulaCell...
     P                 B                   EXPORT
     D callbackFormulaCell...
     D                 PI                  static
     D  Sheet                      1024A   const varying
     D  Row                          10I 0 value
     D  Col                           5I 0 value
     D  Value                         8F   value
     D  Nan                           5I 0 value
     D  Formula                   32767A   const varying
      /free
          if (Last.Row<>Row or Last.Sheet<>Sheet);
              if (Last.Row>=0 and pEndRowProc<>*NULL);
                 EndRowProc(Last.Sheet: Last.Row);
              endif;
              if (pNewRowProc<>*NULL);
                 NewRowProc(Sheet: Row);
              endif;
              Last.Sheet = Sheet;
              Last.Row   = Row;
          endif;

          if (pFormulaProc <> *NULL);
             if (FormulaProc(Sheet: Row: Col: Value: NaN: Formula) = *On);
                escape(1: 'End Of Data');
             endif;
          endif;

      /end-free
     P                 E

      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * Escape():
      *   This sends back a fatal error message (an "escape" message)
      *   with MSGID CPF9897 to the specified level in the call stack,
      *   ending any higher level programs.
      *
      *   peStackCnt = (input) Specifies which program's msgq to send
      *       *ESCAPE message to by specifying a number of levels back...
      *   peMsgTxt   = (input) Text of message to send
      *
      * Returns *OFF if it failed.  If it succeeds, this routine
      *   does not return, since it's call level is ended.
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P Escape          B
     D Escape          PI             1N
     D   StackCnt                    10I 0 value
     D   MsgTxt                     256A   const

     D QMHSNDPM        PR                  ExtPgm('QMHSNDPM')
     D   MessageID                    7A   Const
     D   QualMsgF                    20A   Const
     D   MsgData                    256A   Const
     D   MsgDtaLen                   10I 0 Const
     D   MsgType                     10A   Const
     D   CallStkEnt                  10A   Const
     D   CallStkCnt                  10I 0 Const
     D   MessageKey                   4A
     D   ErrorCode                 1024A   options(*varsize)

     D dsEC            DS
     D  BytesProv                    10I 0 inz(0)
     D  BytesAvail                   10I 0 inz(0)

     D MsgLen          S             10I 0
     D MsgKey          S              4A

      /free

         MsgLen = %len(%trimr(MsgTxt));
         if (MsgLen < 1);
            return *off;
         endif;

         QMHSNDPM( 'CPF9897'
                 : 'QCPFMSG   *LIBL'
                 : MsgTxt
                 : MsgLen
                 : '*ESCAPE'
                 : '*'
                 : StackCnt
                 : MsgKey
                 : dsEC );

         return *off;

      /end-free
     P                 E
