/*
 * Decompiled with CFR 0.152.
 */
package com.iseriesnetwork.clubtech.xlparse;

import com.iseriesnetwork.clubtech.xlparse.ParseSheetCallback;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.DateWindow1904Record;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.UnicodeString;

public class ParseSheetListener
implements HSSFListener {
    private SSTRecord sstrec;
    private String[] sheetName = new String[256];
    private int activeSheet = -1;
    private int numSheets = -1;

    public void processRecord(Record record) {
        switch (record.getSid()) {
            case 2057: {
                BOFRecord bOFRecord = (BOFRecord)record;
                if (bOFRecord.getType() != 16) break;
                System.out.println("*** Active #" + Integer.toString(this.activeSheet));
                ++this.activeSheet;
                break;
            }
            case 133: {
                BoundSheetRecord boundSheetRecord = (BoundSheetRecord)record;
                ++this.numSheets;
                System.out.println("*** Sheet #" + Integer.toString(this.numSheets));
                this.sheetName[this.numSheets] = boundSheetRecord.getSheetname();
                System.out.println("*** Sheet =" + this.sheetName[this.numSheets]);
                break;
            }
            case 515: {
                NumberRecord numberRecord = (NumberRecord)record;
                if (this.activeSheet == -1) break;
                ParseSheetCallback.callbackNumericCell(this.sheetName[this.activeSheet].getBytes(), numberRecord.getRow(), numberRecord.getColumn(), numberRecord.getValue());
                break;
            }
            case 252: {
                this.sstrec = (SSTRecord)record;
                break;
            }
            case 253: {
                LabelSSTRecord labelSSTRecord = (LabelSSTRecord)record;
                if (this.activeSheet == -1) break;
                UnicodeString unicodeString = this.sstrec.getString(labelSSTRecord.getSSTIndex());
                byte[] byArray = unicodeString.getString().getBytes();
                ParseSheetCallback.callbackStringCell(this.sheetName[this.activeSheet].getBytes(), labelSSTRecord.getRow(), labelSSTRecord.getColumn(), byArray);
                break;
            }
            case 6: {
                FormulaRecord formulaRecord = (FormulaRecord)record;
                if (this.activeSheet == -1) break;
                Double d = new Double(formulaRecord.getValue());
                short s = 0;
                String string = formulaRecord.toString();
                byte[] byArray = string.getBytes();
                if (d.equals(new Double(Double.NaN))) {
                    s = 1;
                }
                ParseSheetCallback.callbackFormulaCell(this.sheetName[this.activeSheet].getBytes(), formulaRecord.getRow(), formulaRecord.getColumn(), formulaRecord.getValue(), s, byArray);
                break;
            }
            case 34: {
                DateWindow1904Record dateWindow1904Record = (DateWindow1904Record)record;
                System.out.println("Date Format Encountered");
            }
        }
    }
}

