#!/bin/sh
FTPSCRIPT=clubtech.fts
HOST=$1
LIB=$2
USER=$3
PASS=$4

usage() {
   echo " "
   echo "USAGE: ./ftpsrc.sh HOST LIB USERID PASSWORD"
   echo " "
   echo "     HOST = FTP server to send to (ex: as400.example.com)"
   echo "      LIB = IBM i library to put source code into (ex: QGPL)"
   echo "   USERID = UserID to log in with"
   echo " PASSWORD = Password to log in with"
   echo " "
}

buildscript() {
   echo "user $USER $PASS"
   echo "cd /qsys.lib/qgpl.lib"
   echo "quote site namefmt 0"
   echo "quote rcmd crtsrcpf file($LIB/QCLSRC) rcdlen(92)"
   echo "quote rcmd crtsrcpf file($LIB/QRPGLESRC) rcdlen(112)"
   echo "quote rcmd crtsrcpf file($LIB/QSRVSRC) rcdlen(92)"
   echo "quote rcmd crtsrcpf file($LIB/QsqlSRC) rcdlen(92)"
   echo "ascii"
   echo "put buildhssf.clp $LIB/QCLSRC.buildhssf"
   echo "quote rcmd chgpfm file($LIB/QCLSRC) mbr(buildhssf) srctype(clp)"
   echo "ascii"
   echo "put addpic.rpgle $LIB/QRPGLESRC.addpic"
   echo "quote rcmd chgpfm file($LIB/QRPGLESRC) mbr(addpic) srctype(rpgle)"
   echo "ascii"
   echo "put colordemo.rpgle $LIB/QRPGLESRC.colordemo"
   echo "quote rcmd chgpfm file($LIB/QRPGLESRC) mbr(colordemo) srctype(rpgle)"
   echo "ascii"
   echo "put hdrdemo.rpgle $LIB/QRPGLESRC.hdrdemo"
   echo "quote rcmd chgpfm file($LIB/QRPGLESRC) mbr(hdrdemo) srctype(rpgle)"
   echo "ascii"
   echo "put hssf_h.rpgle $LIB/QRPGLESRC.hssf_h"
   echo "quote rcmd chgpfm file($LIB/QRPGLESRC) mbr(hssf_h) srctype(rpgle)"
   echo "ascii"
   echo "put hssfr4.rpgle $LIB/QRPGLESRC.hssfr4"
   echo "quote rcmd chgpfm file($LIB/QRPGLESRC) mbr(hssfr4) srctype(rpgle)"
   echo "ascii"
   echo "put ifsio_h.rpgle $LIB/QRPGLESRC.ifsio_h"
   echo "quote rcmd chgpfm file($LIB/QRPGLESRC) mbr(ifsio_h) srctype(rpgle)"
   echo "ascii"
   echo "put upddemo.rpgle $LIB/QRPGLESRC.upddemo"
   echo "quote rcmd chgpfm file($LIB/QRPGLESRC) mbr(upddemo) srctype(rpgle)"
   echo "ascii"
   echo "put xlcrtdemo.rpgle $LIB/QRPGLESRC.xlcrtdemo"
   echo "quote rcmd chgpfm file($LIB/QRPGLESRC) mbr(xlcrtdemo) srctype(rpgle)"
   echo "ascii"
   echo "put hssfr4.bnd $LIB/QSRVSRC.hssfr4"
   echo "quote rcmd chgpfm file($LIB/QSRVSRC) mbr(hssfr4) srctype(bnd)"
   echo "ascii"
   echo "put divsales.sql $LIB/QsqlSRC.divsales"
   echo "quote rcmd chgpfm file($LIB/QsqlSRC) mbr(divsales) srctype(sql)"
   echo "quit"
}

if test "x$HOST" = "x" -o "x$LIB" = "x" -o "x$USER" = "x" -o "x$PASS" = "x"; then
  usage
  exit 1
fi

buildscript > $FTPSCRIPT
ftp -n $HOST < $FTPSCRIPT
rm -f $FTPSCRIPT
