      *  Demonstration of using HSSF to create a complex Excel workbook
      *
      *  To compile:
      *      Make sure you've already created HSSFR4. See the instructions
      *      on that source member for details.
      *
      *      CRTPF DIVSALES SRCFILE(xxx/xxx)
      *      CRTBNDRPG PGM(XLCRTDEMO) SRCFILE(xxx/xxx) DBGVIEW(*LIST)
      *
      *
     H DFTACTGRP(*NO)
     H OPTION(*SRCSTMT: *NODEBUGIO: *NOSHOWCPY)
     H THREAD(*SERIALIZE)
     H BNDDIR('HSSF')

     FDIVSALES  IF   E           K DISK

      /copy hssf_h

     D CreateCellStyles...
     D                 PR

     D AddMonth        PR
     D   book                              like(HSSFWorkbook)
     D   month                        2P 0 value
     D   monthname                   20A   varying const

     D FormatColumns   PR
     D   sheet                             like(HSSFSheet)

     D SetHeadings     PR
     D   sheet                             like(HSSFSheet) const
     D   monthname                   20A   varying const
     D   rowcount                    10I 0

     D book            s                   like(HSSFWorkbook)
     D LgHeading       s                   like(HSSFCellStyle)
     D SmHeading       s                   like(HSSFCellStyle)
     D ColHeading      s                   like(HSSFCellStyle)
     D Numeric         s                   like(HSSFCellStyle)
     D Text            s                   like(HSSFCellStyle)
     D Dates           s                   like(HSSFCellStyle)

      /free

        hssf_begin_object_group(100);

        book = new_HSSFWorkbook();
        CreateCellStyles();

        AddMonth(book:  1: 'January');
        AddMonth(book:  2: 'February');
        AddMonth(book:  3: 'March');
        AddMonth(book:  4: 'April');
        AddMonth(book:  5: 'May');
        AddMonth(book:  6: 'June');
        AddMonth(book:  7: 'July');
        AddMonth(book:  8: 'August');
        AddMonth(book:  9: 'September');
        AddMonth(book: 10: 'October');
        AddMonth(book: 11: 'November');
        AddMonth(book: 12: 'December');

        HSSF_save(book: '/tmp/xldemo3.0.1.xls');

        hssf_end_object_group();
        *inlr = *on;

      /end-free


      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * CreateCellStyles(): Create the different display styles
      *    used for cells in this Excel workbook.
      *
      * NOTE: Uses the following global variables:
      *       Book, LgHeading, SmHeading, ColHeading, Numeric
      *       Text, Dates.
      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P CreateCellStyles...
     P                 B
     D CreateCellStyles...
     D                 PI

     D LgFont          s                   like(HSSFFont)
     D SmFont          s                   like(HSSFFont)
     D ChFont          s                   like(HSSFFont)
     D DataFmt         s                   like(HSSFDataFormat)
     D TempStr         s                   like(jString)
     D NumFmt          s              5I 0
     D DateFmt         s              5I 0

      /free

         //
         //  Create a cell style for the large, centered
         //  title at the top of the report.
         //
         LgHeading = HSSFWorkbook_createCellStyle(book);

         LgFont = HSSFWorkbook_createFont(book);
         HSSFFont_setBoldweight(LgFont: BOLDWEIGHT_BOLD);
         HSSFFont_setFontHeightInPoints(LgFont: 16);
         HSSFCellStyle_setFont(LgHeading: LgFont);

         HSSFCellStyle_setAlignment(LgHeading: ALIGN_CENTER);

         //
         // Create a cell style for the smaller text that
         //  will be printed below the main heading.
         //

         SmHeading = HSSFWorkbook_createCellStyle(book);

         SmFont = HSSFWorkbook_createFont(book);
         HSSFFont_setFontHeightInPoints(SmFont: 8);
         HSSFCellStyle_setFont(SmHeading: SmFont);

         HSSFCellStyle_setAlignment(SmHeading: ALIGN_CENTER);

         //
         // Create a cell style for the column headings.
         // These are bold and have a border line at the bottom
         //

         ColHeading = HSSFWorkbook_createCellStyle(book);

         ChFont = HSSFWorkbook_createFont(book);
         HSSFFont_setBoldweight(ChFont: BOLDWEIGHT_BOLD);
         HSSFCellStyle_setFont(ColHeading: ChFont);

         HSSFCellStyle_setAlignment(ColHeading: ALIGN_CENTER);
         HSSFCellStyle_setBorderBottom(ColHeading: BORDER_THIN);

         //
         // Create a cell style for numbers so that they are
         //  right-aligned and the number is formatted nicely.
         //

         Numeric = HSSFWorkbook_createCellStyle(book);

         DataFmt = HSSFWorkbook_createDataFormat(book);
         TempStr = new_String('#,##0.00');
         NumFmt = HSSFDataFormat_getFormat(DataFmt: TempStr);
         HSSFCellStyle_setDataFormat(Numeric: NumFmt);

         HSSFCellStyle_setAlignment(Numeric: ALIGN_RIGHT);

         //
         // Create a cell style for text so that it's
         //  left-aligned
         //

         Text = HSSFWorkbook_createCellStyle(book);
         HSSFCellStyle_setAlignment(Text: ALIGN_LEFT);

         //
         // Create a cell style for dates.  Dates in Excel
         //  are numbers that are formatted in a particular
         //  way.
         //

         Dates = HSSFWorkbook_createCellStyle(book);

         DataFmt = HSSFWorkbook_createDataFormat(book);
         TempStr = new_String('m/d/yy');
         DateFmt = HSSFDataFormat_getFormat(DataFmt: TempStr);
         HSSFCellStyle_setDataFormat(Dates: DateFmt);

      /end-free
     P                 E


      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      *  AddMonth():  Add 1 months data to the given sheet
      *
      *      month = (input) month number (1=January - 12=December)
      *  monthname = (input) human-readable month name ('January')
      *       book = (input) HSSF Workbook to add sheet to
      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P AddMonth        B
     D AddMonth        PI
     D   book                              like(HSSFWorkbook)
     D   month                        2P 0 value
     D   monthname                   20A   varying const

     D sheet           s                   like(HSSFSheet)
     D row             s                   like(HSSFRow)
     D rowcount        s             10I 0 inz(0)
     D start           s              5A   varying
     D end             s              5A   varying
     D AddFormula      s              1N   inz(*OFF)

      /free

         sheet = HSSF_newSheet(book: monthname);

         FormatColumns(sheet);
         SetHeadings(sheet: monthname: rowcount);
         start = hssf_cellname( rowcount+1: 3);


         setll (month) DIVSALES;
         reade (month) DIVSALES;

         dow not %eof(DIVSALES);

            rowcount += 1;
            row = HSSFSheet_createRow(sheet: rowcount);

            hssf_text( row: 0 : %char(DIVNO)   : Text);
            hssf_text( row: 1 : %trimr(DIVNAME): Text);
            hssf_date( row: 2 : PostDate       : Dates);
            hssf_num ( row: 3 : Sales          : Numeric);
            AddFormula = *On;

            reade (month) DIVSALES;
         enddo;

         if (AddFormula);

            end = hssf_cellname( rowcount: 3);

            rowcount += 2;
            row = HSSFSheet_createRow(sheet: rowcount);
            hssf_text   ( row: 2 : 'Total:'                : Text);
            hssf_formula( row: 3: 'SUM('+start+':'+end+')': Numeric);

         endif;

      /end-free
     P                 E


      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * FormatColumns():  Set the column widths & merged cells
      *    in a given worksheet.
      *
      *   sheet = (input) sheet to set the column widths in
      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P FormatColumns   B
     D FormatColumns   PI
     D   sheet                             like(HSSFSheet)
      /free

        //
        // The column width setting is in units that are approx
        //   1/256 of a character.
        //

        HSSFSheet_setColumnWidth( sheet: 0:  3 * 256 );
        HSSFSheet_setColumnWidth( sheet: 1: 30 * 256 );
        HSSFSheet_setColumnWidth( sheet: 2: 10 * 256 );
        HSSFSheet_setColumnWidth( sheet: 3: 15 * 256 );

        //
        //  in the first 3 rows of the spreadsheet, the cells
        //  for the first 4 columns are merged together, since
        //  the one resulting cell is used for a heading
        //

        hssf_merge(sheet: 0: 0: 0: 3);
        hssf_merge(sheet: 1: 0: 1: 3);
        hssf_merge(sheet: 2: 0: 2: 3);

      /end-free
     P                 E


      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * SetHeadings():  Set the text in the first few rows of
      *    the given worksheet so that they appear like "headings"
      *    to someone viewing the sheet.
      *
      *    sheet = (input) sheet that cells are set in.
      * rowcount = (input/output) row count (updated)
      *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P SetHeadings     B
     D SetHeadings     PI
     D   sheet                             like(HSSFSheet) const
     D   monthname                   20A   varying const
     D   rowcount                    10I 0

     D row             s                   like(HSSFRow)
      /free

         row = HSSFSheet_createRow(sheet: rowcount);
         hssf_text( row: 0 : 'Big Big Corporation': LgHeading);

         rowcount += 1;
         row = HSSFSheet_createRow(sheet: rowcount);
         hssf_text( row: 0 : 'Weekly Sales Figures': SmHeading);

         rowcount += 1;
         row = HSSFSheet_createRow(sheet: rowcount);
         hssf_text( row: 0 : 'for the month of ' + monthname: SmHeading);

         rowcount += 2;
         row = HSSFSheet_createRow(sheet: rowcount);
         hssf_text( row: 0 : 'Div':           ColHeading);
         hssf_text( row: 1 : 'Division Name': ColHeading);
         hssf_text( row: 2 : 'Date':          ColHeading);
         hssf_text( row: 3 : 'Sales':         ColHeading);

      /end-free
     P                 E
