     H DFTACTGRP(*NO)
     H OPTION(*SRCSTMT: *NODEBUGIO: *NOSHOWCPY)
     H THREAD(*SERIALIZE)
     H BNDDIR('HSSF')

      /copy hssf_h

     D book            s                   like(HSSFWorkbook)
     D sheet           s                   like(HSSFSheet)
     D row             s                   like(HSSFRow)
     D cell            s                   like(HSSFCell)
     D TempStr         s                   like(jString)
     D StrVal          s             52A   varying
     D NumVal          s              8F
     D type            s             10I 0

     D String_getBytes...
     D                 pr          1024A   varying
     D                                     extproc(*JAVA:
     D                                     'java.lang.String':
     D                                     'getBytes')

      /free

        hssf_begin_object_group(100);

        //
        // Load an existing spreadsheet into memory
        //
        book = hssf_open('/tmp/xldemo3.0.1.xls');

        //
        // get the HSSFCell object that needs changing
        //
        sheet = hssf_getSheet(book: 'January');
        row = HSSFSheet_getRow(sheet: 5);
        cell = HSSFRow_GetCell(row: 1);

        //
        // Change the cell to a String cell and set the
        //  value to 'Nifty New Value'
        //
        HSSFCell_setCellType(cell: CELL_TYPE_STRING);
        TempStr = new_String('Nifty New Value');
        HSSFCell_setCellValueStr(cell: TempStr);

        //
        //  See what the value of the cell in row 7, column 2 is:
        //
        row = HSSFSheet_getRow(sheet: 7);
        cell = HSSFRow_GetCell(row: 2);
        type = HSSFCell_getCellType(cell);
        StrVal = 'Cell C8 = ';

        select;
        when type = CELL_TYPE_STRING;
           StrVal += String_getBytes(HSSFCell_getStringCellValue(cell));
        when type = CELL_TYPE_FORMULA;
           StrVal += String_getBytes(HSSFCell_getCellFormula(cell));
        when type = CELL_TYPE_NUMERIC;
           NumVal = HSSFCell_getNumericCellValue(cell);
           StrVal += %char(%dech(NumVal:15:2));
        endsl;

        dsply StrVal;

        hssf_save(book: '/tmp/xldemo3.0.1.xls');
        hssf_end_object_group();

        *inlr = *on;

      /end-free
