      *  Demonstration of loading an image into an Excel spreadsheet
      *                               Scott Klement, December 11, 2008
      *
      *    To compile:
      *      - Change IFSDIR, below, to an appropriate directory.
      *      - Make sure SKLogo.png has been uploaded to the IFSDIR
      *          location.  If you're using FTP to upload SKLogo.png
      *          make sure you use BINARY mode.
      *      - Make sure you've built HSSFR4.  See the HSSFR4
      *          source member for build instructions.
      *      - run the following:
      *>     CRTBNDRPG ADDPIC DBGVIEW(*LIST)
      *
      *
     H DFTACTGRP(*NO) BNDDIR('HSSF')

      /copy hssf_h

     D IFSDIR          C                   '/home/klemscot'

     D book            s                   like(HSSFWorkbook)
     D sheet           s                   like(HSSFSheet)
     D row             s                   like(HSSFRow)
     D NameStyle       s                   like(HSSFCellStyle)
     D AddrStyle       s                   like(HSSFCellStyle)
     D img             s                   like(HSSFPicture)
     D Pat             s                   like(HSSFPatriarch)
     D Anc             s                   like(HSSFClientAnchor)
     D Pic             s            500a   varying
     D idx             s             10i 0

      /free
          hssf_begin_object_group(10000);
          book = new_HSSFWorkbook();
          sheet = hssf_newSheet(book: 'Test');

          // ------------------------------------------
          // Create a large bold font for my name
          // ------------------------------------------

          NameStyle = HSSFWorkbook_createCellStyle( book );
          HSSFCellStyle_setFont( NameStyle
                               : hssf_CreateFont( book
                                                : 'Arial'
                                                : 36
                                                : BOLDWEIGHT_BOLD
                                                : *OMIT
                                                : *OMIT
                                                : *OMIT
                                                : *OMIT
                                                : *OMIT ) );

          // ------------------------------------------
          // Create a medium-sized italic font for
          //  my address
          // ------------------------------------------

          AddrStyle = HSSFWorkbook_createCellStyle( book );
          HSSFCellStyle_setFont( AddrStyle
                               : hssf_CreateFont( book
                                                : 'Arial'
                                                : 16
                                                : *OMIT
                                                : *OMIT
                                                : *ON
                                                : *OMIT
                                                : *OMIT
                                                : *OMIT ) );

          // ------------------------------------------
          //  Load my logo into the workbook
          // ------------------------------------------

          Pic = IFSDIR + '/SKLogo.png';
          idx = HSSF_addPicture(book: Pic: HSSF_PIC_PNG);

          // ------------------------------------------
          //   Put my name and address in cells...
          // ------------------------------------------

          row = HSSFSheet_createRow(sheet: 0);
          hssf_text(row: 0: 'Scott Klement': NameStyle);

          row = HSSFSheet_createRow(sheet: 1);
          hssf_text(row: 0: '123 Main Street': AddrStyle);

          row = HSSFSheet_createRow(sheet: 2);
          hssf_text(row: 0: 'Milwaukee, WI 53201': AddrStyle);

          // ------------------------------------------
          //   Anchors are always specified by the
          //   upper-left cell and the lower-right
          //   cell to create a rectangle.
          //
          //   Draw the logo from cells 6,0 (G1) to
          //   cells 8,6 (I7)
          // ------------------------------------------

          Pat = HSSFSheet_createDrawingPatriarch(sheet);
          Anc = new_HSSFClientAnchor( 512: 128: 512: 128
                                    :   6:   0:   8:   6);
          HSSFClientAnchor_setAnchorType(Anc: HSSF_ANCHOR_MOVE);
          img = HSSFPatriarch_createPicture(pat: anc: idx);

          // enable this to force picture to it's original
          //  (unscaled) size:
          // HSSFPicture_resetSize(img);

          // ------------------------------------------
          //  Save workbook to the IFS
          // ------------------------------------------

          hssf_save(book: IFSDIR + '/pictest.xls');
          hssf_end_object_group();
          *inlr = *on;
      /end-free
